<?php
/**************************************************************
* Nome:    CCRelat
* Autor:   Valnei M. Lorenzetti
* Data:   2008-08-31 (V1.0.0)
* Descr.:  Relatorios
*************************************************************/

/**************************************************************
Area dos includes
*************************************************************/
$DirRaiz = $_SERVER['DOCUMENT_ROOT'].'/vdt/';
include_once($DirRaiz.'config.php');
include_once($DirRaiz.'config.cc.php');
$Modulo = $DirCCen;
include_once($DirRaiz.$Modulo.$DirClass.'monitor.class.php');
include_once($DirRaiz.$DirModul.'geral.modu.php');
include_once($DirRaiz.'libs/PHPExcel/PHPExcel.php');


/**************************************************************
Definicao de variaveis
*************************************************************/
$Moni  = new Monitores;  // Objeto monitor
$L_var = $_POST;         // Recebe as variaveis do formulario


/**************************************************************
Programa Principal
*************************************************************/
$Arquivo = brancos_por_sublinhado($L_var['t'].' '.$L_var['m'].'.xls');
for ($x=0; $x<$L_var['tg']; $x++) $LFilas[$x] = $L_var['g'.$x];
echo abandonadas_dia($LFilas, $L_var['d'], $L_var['a'], $L_var['tp'], $L_var['na'], $tipoNS, $L_var['tcf'], $L_var['filuf']);
return;



/**************************************************************
Funcao planilha_operadores
*************************************************************/
function abandonadas_dia($Filas, $Per_d, $Per_a, $Tipo_per, $MinimoEspera, $tipoNs, $tempoCon, $ufs){
    global $Moni;

    $dataAtual = date("d/m/Y");
    $hoje = 0;
    $ufs = explode(",", $ufs);
    //Arrumada as datas para timestamp
    list ($data_d, $horario_d) = explode (' ', $Per_d); 
    list ($dia_d, $mes_d, $ano_d) = explode ('/', $data_d); 
    list ($hora_d, $minuto_d) = explode (':', $horario_d);
    if($dataAtual == $data_d) $hoje = 1;
    
    list ($data_a, $horario_a) = explode (' ', $Per_a); 
    list ($dia_a, $mes_a, $ano_a) = explode ('/', $data_a); 
    list ($hora_a, $minuto_a) = explode (':', $horario_a);
    if(($dataAtual != $data_a) || ($hoje != 1)) $hoje = 0;

    $Auy_d = mktime($hora_d, $minuto_d, 0, $mes_d, $dia_d, $ano_d); // $Aux_d = $ano_d.'-'.$mes_d.'-'.$dia_d.' '.$hora_d.':'.$minuto_d;
    $Auy_a = mktime($hora_a, $minuto_a, 0, $mes_a, $dia_a, $ano_a); // $Aux_a = $ano_a.'-'.$mes_a.'-'.$dia_a.' '.$hora_a.':'.$minuto_a;
    
    if (!($Auy_d) || ($Auy_d<0)) return "Período inválido";
    if (!($Auy_a) || ($Auy_a<0)) return "Período inválido";
    if ($Auy_d > $Auy_a) return "Período inválido";
    
    $anos=$ano_d;
    
    $Tabela = array();
    $Saida = '';

    for ($F=0; $F<count($Filas); $F++) {
        $anos=$ano_d;
        while ($anos<=$ano_a) {
            $meses=$mes_d;
            while ( ($meses<=$mes_a) && ($anos<=$ano_a) ) {
                if ($meses==$mes_d) $dia_d1 = $dia_d;
                else $dia_d1 = '01';
                if ($meses==$mes_a) $dia_a1 = $dia_a;
                else $dia_a1 = $Totaldiasmensais[$meses-1];

                for ($dias=$dia_d1; $dias<=$dia_a1; $dias++) {
                    if ($Tipo_per=="E") {
                        $Vale = monta_horario_expediente($ano_d.'-'.$meses.'-'.$dias,$Filas[$F]);
                        if (!$Vale) continue;
                        $h1 = explode(":",$Vale[0]); $hora_ini = $h1[0]; $minuto_ini = $h1[1];
                        $h2 = explode(":",$Vale[1]); $hora_fim = $h2[0]; $minuto_fim = $h2[1];
                    } elseif ($Tipo_per=="T") {
                        if (($meses==$mes_d) && ($dias==$dia_d)) {
                            $hora_ini = $hora_d; $minuto_ini = $minuto_d;
                        } else {
                            $hora_ini = '00'; $minuto_ini = '00';
                        }
                        
                        if (($meses==$mes_a) && ($dias==$dia_a)) {
                            $hora_fim = $hora_a; $minuto_fim = $minuto_a;
                        } else {
                            $hora_fim = '23'; $minuto_fim = '59';
                        }
                    } else {
                        $hora_ini = $hora_d; $minuto_ini = $minuto_d;
                        $hora_fim = $hora_a; $minuto_fim = $minuto_a;
                    }

                    $Aux_d = $ano_d.'-'.$meses.'-'.$dias.' '.$hora_ini.':'.$minuto_ini;
                    $Aux_a = $ano_a.'-'.$meses.'-'.$dias.' '.$hora_fim.':'.$minuto_fim;
                    
                    $dias = intval($dias,10);

                    if($hoje == 0) $Tab1 = $Moni->relatorio_filas_geral($Filas[$F], $Aux_d, $Aux_a, $MinimoEspera, '', 'relat', '', $filtroNumero);
                    if($hoje == 1) $Tab1 = $Moni->relatorio_filas_geral($Filas[$F], $Aux_d, $Aux_a, $MinimoEspera, 'hoje', 'monit', '', $filtroNumero);

                    $Tabela[$Filas[$F]]['Ano'][intval($ano_d, 10)]['Mes'][intval($meses, 10)]['Dia'][intval($dias, 10)] = $Tab1;
                }

                $meses++;
                if ($meses==13) {
                    $meses=1;
                    $anos++;
                }
            }
            $anos++;
        }
    }

    return monta_relatorio($Filas, $Tabela, array($dia_d, $mes_d, $ano_d), array($dia_a, $mes_a, $ano_a));
}

function monta_relatorio($filas, $dados, $de, $a){
    global $DirRaiz, $DirDownl, $Arquivo;
    $debug = "";

    $dadosArray = [];
    $dadosArray["tipo"] = "Ligacoes abandonadas por dia";
    
    $dia_d = intval($de[0], 10);
    $mes_d = intval($de[1], 10);
    $ano_d = intval($de[2], 10);
    $dia_a = intval($a[0], 10);
    $mes_a = intval($a[1], 10);
    $ano_a = intval($a[2], 10);

    $diaSemana = array('Domingo', 'Segunda', 'Terça', 'Quarta', 'Quinta', 'Sexta', 'Sábado');

    $tabela[0][] = "Rótulos de linha";
    $tabela[0][] = "Após 20s";
    $tabela[0][] = "Até 20s";
    $tabela[0][] = "Não atendida";
    $tabela[0][] = "Total geral";

    $phpExcel = new PHPExcel();

    for($i = 0; $i < count($filas); $i++){
        $linha = 1;
        if($i > 0) $worksheet = $phpExcel->createSheet($i);
        else $worksheet = $phpExcel->getActiveSheet();

        $worksheet->setTitle($filas[$i], false);
        $worksheet->getStyle("A")->getFont()->setBold(true);
        $worksheet->getStyle("1")->getFont()->setBold(true);
        $worksheet->getColumnDimensionByColumn(0)->setAutoSize(true);
        $colNumber = 0;

        $anos = $ano_d;
        while($anos <= $ano_a) {
            $meses = $mes_d;
            while(($meses <= $mes_a) && ($anos <= $ano_a) ) {
                if($meses == $mes_d) $dia_d1 = $dia_d;
                else $dia_d1 = '01';
                if($meses == $mes_a) $dia_a1 = $dia_a;
                else $dia_a1 = $Totaldiasmensais[$meses-1];

                for($dias = $dia_d1; $dias <= $dia_a1; $dias++) {

                    $atendMenorTempoMax = $dados[$filas[$i]]['Ano'][$anos]['Mes'][$meses]['Dia'][$dias]['Quantidade chamadas atendidas com tempo espera <= maximo'];
                    $atendMenorTempoMax = (intval($atendMenorTempoMax, 10) != "") ? intval($atendMenorTempoMax, 10) : 0;

                    $atendMaiorTempoMax = $dados[$filas[$i]]['Ano'][$anos]['Mes'][$meses]['Dia'][$dias]['Quantidade chamadas atendidas com tempo espera > maximo'];
                    $atendMaiorTempoMax = (intval($atendMaiorTempoMax, 10) != "") ? intval($atendMaiorTempoMax, 10) : 0;

                    $desistencias = $dados[$filas[$i]]['Ano'][$anos]['Mes'][$meses]['Dia'][$dias]['Quantidade desistencias'];
                    $desistencias = (intval($desistencias, 10) != "") ? intval($desistencias, 10) : 0;

                    $total = $atendMenorTempoMax + $atendMaiorTempoMax + $desistencias;
                    $total = (intval($total, 10) != "") ? intval($total, 10) : 0;

                    $data = date('Y-m-d', mktime(0, 0, 0, $meses, $dias, $anos));
                    $nomeDiaSemana = $diaSemana[date('w', strtotime($data))];

                    $tabela[$linha][0] = $nomeDiaSemana." (".$dias."/".$meses."/".$anos.")";
                    $tabela[$linha][1] = strval($atendMaiorTempoMax);
                    $tabela[$linha][2] = strval($atendMenorTempoMax);
                    $tabela[$linha][3] = strval($desistencias);
                    $tabela[$linha][4] = strval($total);
                    $linha++;
                    
                    $dadosArray['dados'][$filas[$i]]['datas'][] = $nomeDiaSemana." (".$dias."/".$meses."/".$anos.")";
                    $dadosArray['dados'][$filas[$i]]['atendMaiorTempoMax'][] = $atendMaiorTempoMax;
                    $dadosArray['dados'][$filas[$i]]['atendMenorTempoMax'][] = $atendMenorTempoMax;
                    $dadosArray['dados'][$filas[$i]]['desistencias'][] = $desistencias;
                    $dadosArray['dados'][$filas[$i]]['total'][] = $total;

                    $colNumber++;
                    $worksheet->getColumnDimensionByColumn($colNumber)->setAutoSize(true);
                }

                $meses++;
                if ($meses==13) {
                    $meses=1;
                    $anos++;
                }
            }
            $anos++;
        }

        $worksheet->fromArray($tabela);

        /***************************
         **** Criando o gráfico ****
         ***************************/

        //Seta as labels
        $dataSeriesLabels = array(
            new PHPExcel_Chart_DataSeriesValues('String', $filas[$i].'!$B$1', NULL, 1),   //Após 20s
            new PHPExcel_Chart_DataSeriesValues('String', $filas[$i].'!$C$1', NULL, 1),   //Até 20s
            new PHPExcel_Chart_DataSeriesValues('String', $filas[$i].'!$D$1', NULL, 1),    //Não atendida
            new PHPExcel_Chart_DataSeriesValues('String', $filas[$i].'!$E$1', NULL, 1)    //Não atendida
        );

        //Seta as labels do eixo X
        $xAxisTickValues = array(
            new PHPExcel_Chart_DataSeriesValues('String', $filas[$i].'!$A$2:A'.count($tabela), NULL, count($tabela)-1),  //  Q1 to Q4
        );

        //Seta os valores do gráfico
        $dataSeriesValues = array(
            new PHPExcel_Chart_DataSeriesValues('Number', $filas[$i].'!$B$2:$B$'.count($tabela), NULL, count($tabela)-1),
            new PHPExcel_Chart_DataSeriesValues('Number', $filas[$i].'!$C$2:$C$'.count($tabela), NULL, count($tabela)-1),
            new PHPExcel_Chart_DataSeriesValues('Number', $filas[$i].'!$D$2:$D$'.count($tabela), NULL, count($tabela)-1),
            new PHPExcel_Chart_DataSeriesValues('Number', $filas[$i].'!$E$2:$E$'.count($tabela), NULL, count($tabela)-1)
        );

        //Constrói o gráfico
        $series = new PHPExcel_Chart_DataSeries(
            PHPExcel_Chart_DataSeries::TYPE_LINECHART,      // plotType
            PHPExcel_Chart_DataSeries::GROUPING_STANDARD,   // plotGrouping
            array(0, 1, 2, 3),                                    // plotOrder
            $dataSeriesLabels,                              // plotLabel
            $xAxisTickValues,                               // plotCategory
            $dataSeriesValues                               // plotValues
        );

        //Define a área de plotagem do gráfico
        $plotArea = new PHPExcel_Chart_PlotArea(NULL, array($series));

        //Define a legenda do gráfico
        $legend = new PHPExcel_Chart_Legend(PHPExcel_Chart_Legend::POSITION_TOPRIGHT, NULL, false);
        $title = new PHPExcel_Chart_Title('Ligações abandonadas na fila '.$filas[$i]);
        $yAxisLabel = new PHPExcel_Chart_Title('Quantidades');

        //Constrói o objeto do gráfico
        $chart = new PHPExcel_Chart(
            'chart1',       // name
            $title,         // title
            $legend,        // legend
            $plotArea,      // plotArea
            true,           // plotVisibleOnly
            0,              // displayBlanksAs
            NULL,           // xAxisLabel
            NULL     // yAxisLabel
        );

        $chart->setTopLeftPosition('F2');
        $chart->setBottomRightPosition('N17');

        //Adiciona o objeto na folha de trabalho
        $worksheet->addChart($chart);
    }

    $objWriter = PHPExcel_IOFactory::createWriter($phpExcel, 'Excel2007');
    $objWriter->setIncludeCharts(TRUE);
    $objWriter->save($DirRaiz.$DirDownl.$Arquivo);

    $dadosArray['html'] = mountHtml($dadosArray);

    return json_encode($dadosArray);
}

function mountHtml($dadosArray){
    $saida = "";

    foreach($dadosArray['dados'] as $fila => $valor){
        $saida .= "<table class='relat'>";

        for($j = 0; $j < 5; $j++){
            if($j == 0){
                $saida .= "<tr><td class='relatT'>Rótulos de linha</td>";
                for($i = 0; $i < count($valor['datas']); $i++){
                    $saida .= "<td class='relatT'>".$valor['datas'][$i]."</td>";
                }
                $saida .= "</tr>";
            } else if($j == 1){
                $saida .= "<tr><td class='relatT'>Após 20s</td>";
                for($i = 0; $i < count($valor['atendMaiorTempoMax']); $i++){
                    $saida .= "<td class='relat'>".$valor['atendMaiorTempoMax'][$i]."</td>";
                }
                $saida .= "</tr>";
            } else if($j == 2){
                $saida .= "<tr><td class='relatT'>Até 20s</td>";
                for($i = 0; $i < count($valor['atendMenorTempoMax']); $i++){
                    $saida .= "<td class='relat'>".$valor['atendMenorTempoMax'][$i]."</td>";
                }
                $saida .= "</tr>";
            } else if($j == 3){
                $saida .= "<tr><td class='relatT'>Desistencias</td>";
                for($i = 0; $i < count($valor['desistencias']); $i++){
                    $saida .= "<td class='relat'>".$valor['desistencias'][$i]."</td>";
                }
            } else if($j == 3){
                $saida .= "<tr><td class='relatT'>Total Geral</td>";
                for($i = 0; $i < count($valor['total']); $i++){
                    $saida .= "<td class='relat'>".$valor['total'][$i]."</td>";
                }
                $saida .= "</tr>";
            }
        }

        $saida .= "<div id='div_grafico_".$fila."'></div>";
    }

    return $saida;
}